/*
 *   libscrobblertag - A media file tag-reader library for AudioScrobbler
 *   Copyright (C) 2003  Pipian
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef TAGS_H
#define TAGS_H 1

/*
 * tag_type byte setup:
 *
 * 0xabcccccc 0xcccdefgh
 *
 * a: READ_ERROR
 * b: CD_AUDIO
 * c: RESERVED
 * d: FLAC
 * e: APE
 * f: Vorbis
 * g: ID3v2
 * h: ID3v1
 *
 */

#define READ_ERROR 0x80
#define CD_AUDIO 0x40
#define NO_TAGS 0x0
#define ID3V1_TAG 0x1
#define ID3V2_TAG 0x2
#define VORBIS_TAG 0x4
#define APE_TAG 0x8
#define FLAC_TAG 0x10

typedef struct {
	unsigned char	*artist,
			*title,
			*mb,
			*album;
	char		tag_type[2];
} metadata;

char *tag_exists(char *);
metadata get_tag_data(char *, char[2]);
void clean_meta(metadata *);
void free_meta(metadata *);
#endif
