#include <stdio.h>
#include <stdlib.h>
#include <curl/curl.h>
#include "tags.h"
#include "queue.h"
#include "fmt.h"

static item_t **q_queue;
static int q_nitems;

static void q_item_free(item_t *item)
{
	if (!item)
		return;
	curl_free(item->artist);
	curl_free(item->title);
	curl_free(item->utctime);
	curl_free(item->mb);
	curl_free(item->album);
	free(item);
}

void q_push(metadata meta, int len)
{
	item_t *item;
	
	q_queue = realloc(q_queue, (q_nitems + 1) * sizeof(item_t *));
	
	item = malloc(sizeof(item_t));
	item->artist = fmt_escape(meta.artist);
	item->title = fmt_escape(meta.title);
	item->utctime = fmt_escape(fmt_timestr(time(NULL), 1));
	snprintf(item->len, sizeof(item->len), "%d", len);
	if(meta.mb == NULL) item->mb = fmt_escape("");
	else item->mb = fmt_escape(meta.mb);
	if(meta.album == NULL) item->album = fmt_escape("");
	else item->album = fmt_escape(meta.album);
	q_queue[q_nitems++] = item;
}

item_t *q_peek(void)
{
	if (!q_nitems)
		return NULL;
	return q_queue[q_nitems - 1];
}

item_t *q_peekall(int rewind)
{
	static int item;
	if (rewind) {
		item = q_nitems;
		return NULL;
	}
	if (--item >= 0)
		return q_queue[item];
	return NULL;
}

int q_pop(void)
{
	item_t *item;
	
	if (!q_nitems)
		return 0;
	item = q_queue[--q_nitems];
	if (!q_nitems) {
		free(q_queue);
		q_queue = NULL;
	} else
		q_queue = realloc(q_queue, q_nitems * sizeof(item_t *));
	q_item_free(item);
	return -1;
}

void q_free(void)
{
	while (q_pop());
}

int q_len(void)
{
	return q_nitems;
}
