/*
 *   libscrobblertag - A media file tag-reader library for AudioScrobbler
 *   Copyright (C) 2003  Pipian
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <curl/curl.h>
#include <stdlib.h>
#include <string.h>
#ifdef __linux__
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <linux/cdrom.h>
#endif
#include "osdep.h"
#include "fmt.h"
/* config.h defines the USER_AGENT */
#include "config.h"

/* Uses ioctl. */
tocData getToC(char *filename)
{
	int i;
	tocData toc_data;

	for(i = 0; i < 100; i++) toc_data.FrameOffset[i] = 0;
	
	#ifdef __linux__
	int drive = open(filename, O_RDONLY | O_NONBLOCK);
	struct cdrom_tochdr tochdr;
	struct cdrom_tocentry tocentry;

	ioctl(drive, CDROMREADTOCHDR, &tochdr);
	toc_data.FirstTrack = tochdr.cdth_trk0;
	toc_data.LastTrack = tochdr.cdth_trk1;
	for (i = tochdr.cdth_trk0; i <= tochdr.cdth_trk1; i++) {
		tocentry.cdte_track = i;
		tocentry.cdte_format = CDROM_LBA;
		ioctl(drive, CDROMREADTOCENTRY, &tocentry);
		toc_data.FrameOffset[i] = tocentry.cdte_addr.lba;
	}
	tocentry.cdte_track = 0xAA;
	tocentry.cdte_format = CDROM_LBA;
	ioctl(drive, CDROMREADTOCENTRY, &tocentry);
	toc_data.FrameOffset[0] = tocentry.cdte_addr.lba;
	close(drive);
	#endif

	return toc_data;
}

/* Uses libcurl */

static int resultRDF_size, errors;

static char *resultRDF, curl_errbuf[CURL_ERROR_SIZE];

static size_t storeRDF(void *ptr, size_t size, size_t nmemb, void *stream)
{
	int len = size * nmemb;

	resultRDF = realloc(resultRDF, resultRDF_size + len);
	memcpy(resultRDF + resultRDF_size, ptr, len);
	resultRDF_size += len;
	return len;
}

char *submitRDF(char *rdfSubmit)
{
	CURL *curl;
	struct curl_slist *list = NULL;
	int status;

	/* Not initing libcurl, as it should already have been by the plugin. */
	curl = curl_easy_init();
	curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 1);
	curl_easy_setopt(curl, CURLOPT_URL, "http://mm.musicbrainz.org/cgi-bin/mq_2_1.pl");
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, storeRDF);
	curl_easy_setopt(curl, CURLOPT_POSTFIELDS, rdfSubmit);
	/*
	 * User Agent should be something like:
	 * For AudioScrobbler:
	 * AudioScrobbler/[protocol version] \n
	 * [Player/Player Version/Plugin Version] [OS]
	 *
	 */
	curl_easy_setopt(curl, CURLOPT_USERAGENT, USER_AGENT);
	list = curl_slist_append(list, "Content-type: text/plain");
	curl_easy_setopt(curl, CURLOPT_HTTPHEADER, list);
	memset(curl_errbuf, 0, sizeof(curl_errbuf));
	curl_easy_setopt(curl, CURLOPT_ERRORBUFFER, curl_errbuf);
	status = curl_easy_perform(curl);
	curl_easy_cleanup(curl);
	if (status)
	{
		pdebug(curl_errbuf);
		errors++;
		return NULL;
	}

	return resultRDF;
}
