#include <wchar.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <stdarg.h>
#include <stdlib.h>
#include <ctype.h>
#include <curl/curl.h>

char *fmt_timestr(time_t t, int gmt)
{
	struct tm *tm;
	static char buf[30];

	tm = gmt ? gmtime(&t) : localtime(&t);
	snprintf(buf, sizeof(buf), "%d-%.2d-%.2d %.2d:%.2d:%.2d",
			tm->tm_year + 1900,
			tm->tm_mon + 1,
			tm->tm_mday,
			tm->tm_hour,
			tm->tm_min,
			tm->tm_sec);
	return buf;
}

char *fmt_escape(char *str)
{
	return curl_escape(str, 0);
}

char *fmt_vastr(char *fmt, ...)
{
	va_list ap;
	static char buf[4096];
	va_start(ap, fmt);
	vsnprintf(buf, sizeof(buf), fmt, ap);
	va_end(ap);
	return buf;
}

void fmt_debug(char *file, char *fun, char *str)
{
	fprintf(stderr, "%s [%s] %s: %s\n", fmt_timestr(time(NULL), 0), 
			file, fun, str);
}

char *fmt_string_pack(char *string, char *fmt, ...)
{
	int buflen = 0, stringlen = 0;
	char buf[4096];
	va_list ap;

	va_start(ap, fmt);
	vsnprintf(buf, sizeof(buf), fmt, ap);
	va_end(ap);
	if(string != NULL) stringlen = strlen(string);
	buflen = strlen(buf);

	string = realloc(string, stringlen + buflen + 1);
	memcpy(string + stringlen, buf, buflen);
	*(string + stringlen + buflen) = 0;
	return string;
}

int fmt_strcasecmp(const char *s1, const char *s2)
{
	int i, ret;
	char *s1n, *s2n;

	s1n = malloc(strlen(s1) + 1);
	s2n = malloc(strlen(s2) + 1);

	for(i = 0; i < strlen(s1) + 1; i++) s1n[i] = tolower(s1[i]);
	for(i = 0; i < strlen(s2) + 1; i++) s2n[i] = tolower(s2[i]);

	/* memleak
	return strcmp(s1n, s2n);
	*/
	ret = strcmp(s1n, s2n);
	free(s1n);
	free(s2n);
	return ret;
}

int fmt_strncasecmp(const char *s1, const char *s2, size_t n)
{
	int i, ret;
	char *s1n, *s2n;

	s1n = malloc(n + 1);
	s2n = malloc(n + 1);

	for(i = 0; i < n; i++) s1n[i] = tolower(s1[i]);
	for(i = 0; i < n; i++) s2n[i] = tolower(s2[i]);
	s1n[n] = 0;
	s2n[n] = 0;
	/* memleak
	return strcmp(s1n, s2n);
	*/
	ret = strcmp(s1n, s2n);
	free(s1n);
	free(s2n);
	return ret;
}
