#ifndef ENDIAN_H
#define ENDIAN_H 1
#define le2int(le) \
((le[0] << 0) | (le[1] << 8) | (le[2] << 16) | (le[3] << 24))
#define le2short(le) \
((le[0] << 0) | (le[1] << 8))
#define be2int(be) \
((be[3] << 0) | (be[2] << 8) | (be[1] << 16) | (be[0] << 24))
#define be24int(be) \
((be[2] << 0) | (be[1] << 8) | (be[0] << 16))
#define be2short(be) \
((be[1] << 0) | (be[0] << 8))
#define flac2int(flac) \
((flac[1] << 16) | (flac[2] << 8) | (flac[3] << 0))
#define synchsafe2int(synch) \
((synch[0] << 21) | (synch[1] << 14) | \
(synch[2] << 7)   | (synch[3] << 0))
#endif

