/*
 *   libaudiotag - A media file tag-reader library
 *   Copyright (C) 2003, 2004  Pipian
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "id3v1.h"
#include "endian.h"
#include "../fmt.h"
#include "../unicode.h"
#define BUFFER_SIZE 4096

static void cleanID3v1(unsigned char *data)
{
	int i;
	
	for(i = 29; i > -1; i--)
	{
		if(data[i] == ' ') data[i] = '\0';
		else break;
	}
}

static void cleanComment(unsigned char *data)
{
	int i;
	
	for(i = 27; i > -1; i--)
	{
		if(data[i] == ' ' || data[i] == '\0') data[i] = '\0';
		else break;
	}
}

int findID3v1(FILE *fp)
{
	char tag_id[4] = "";
	
	fread(tag_id, 1, 3, fp);
	
	if(!strcmp(tag_id, "TAG"))
		return 1;
	else
		return 0;
}

id3v1_t *readID3v1(char *filename)
{
	FILE *fp;
	id3v1_t *id3v1 = NULL;
	int status;
	
	fp = fopen(filename, "rb");
	
	pdebug("Searching for tag...");
	fseek(fp, -128, SEEK_END);
	status = findID3v1(fp);
	if(status)
	{
		unsigned char *data;
		
		id3v1 = malloc(sizeof(id3v1_t));
		memset(id3v1, 0, sizeof(id3v1_t));
		data = malloc(31);
		memset(data, '\0', 31);
		fread(data, 1, 30, fp);
		cleanID3v1(data);
		id3v1->title = realloc(id3v1->title, 31);
		iso88591_to_utf8(data, &id3v1->title);
		fread(data, 1, 30, fp);
		cleanID3v1(data);
		iso88591_to_utf8(data, &id3v1->artist);
		fread(data, 1, 30, fp);
		cleanID3v1(data);
		iso88591_to_utf8(data, &id3v1->album);
		data = realloc(data, 5);
		memset(data, '\0', 5);
		fread(data, 1, 4, fp);
		cleanID3v1(data);
		iso88591_to_utf8(data, &id3v1->year);
		data = realloc(data, 31);
		memset(data, '\0', 31);
		fread(data, 1, 30, fp);
		cleanComment(data);
		id3v1->comment = realloc(id3v1->comment, 31);
		memset(id3v1->comment, 0, 31);
		memcpy(id3v1->comment, data, 30);
		if(data[28] == '\0' && data[29] != '\0')
			id3v1->track = data[29];
		else
			id3v1->track = -1;
		fread(&id3v1->genre, 1, 1, fp);
	}
	
	fclose(fp);
	
	return id3v1;
}

void freeID3v1(id3v1_t *id3v1)
{
	free(id3v1->title);
	free(id3v1->artist);
	free(id3v1->album);
	free(id3v1->year);
	free(id3v1->comment);
	free(id3v1);
}
