#ifndef METATAGS_H
#define METATAGS_H 1

/*
 * tag_type byte setup:
 *
 * 0xabcccccc 0xdefghijk
 *
 * a: READ_ERROR
 * b: CD_AUDIO
 * c: RESERVED
 * d: iTunes
 * e: Speex (Ogg)
 * f: OggFLAC
 * g: FLAC
 * h: APE
 * i: Vorbis
 * j: ID3v2
 * k: ID3v1
 */

#define READ_ERROR 0x80
#define CD_AUDIO 0x40
#define NO_TAGS 0x0
#define ID3V1_TAG 0x1
#define ID3V2_TAG 0x2
#define VORBIS_TAG 0x4
#define APE_TAG 0x8
#define FLAC_TAG 0x10
#define OGGFLAC_TAG 0x20
#define SPEEX_TAG 0x40
#define ITUNES_TAG 0x80

typedef struct {
	unsigned char	*artist,
			*title,
			*mb,
			*album;
	char		tag_type[2];
} metadata_t;

char *tag_exists(char *);
metadata_t *get_tag_data(char *, char[2]);
void clean_meta(metadata_t *);
void free_meta(metadata_t *);
#endif
