#include <xmms/util.h>
#include <xmms/configfile.h>
#include <stdio.h>
#include <string.h>
#include "config.h"
#include "md5.h"

static GtkWidget 	*eduname,
			*edpwd;
void about_show(void)
{
	static GtkWidget *aboutbox;
	gchar *tmp;
	if (aboutbox)
		return;
	tmp = g_strdup_printf("xmms audioscrobbler plugin %s\n\n"
				"Created by Audun Hove <audun@nlc.no>\n", 
				VERSION);
	aboutbox = xmms_show_message(
			"About xmms scrobbler",
			tmp,
			"OK", FALSE, NULL, NULL);
	g_free(tmp);
	gtk_signal_connect(GTK_OBJECT(aboutbox), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &aboutbox);
}

static char *hexify(char *pass, int len)
{
	static char buf[33], *bp = buf;
	char hexchars[] = "0123456789abcdef";
	int i;
	
	memset(buf, 0, sizeof(buf));
	
	for(i = 0; i < len; i++) {
		*(bp++) = hexchars[(pass[i] >> 4) & 0x0f];
		*(bp++) = hexchars[pass[i] & 0x0f];
	}
	*bp = 0;
	return buf;
}

static void saveconfig(GtkWidget *wid, gpointer data)
{
	ConfigFile *cfgfile;
	gchar *pwd;

	pwd = gtk_entry_get_text(GTK_ENTRY(edpwd));
	if ((cfgfile = xmms_cfg_open_default_file())) {
		md5_state_t md5state;
		unsigned char md5pword[16];
	
		xmms_cfg_write_string(cfgfile, "audioscrobbler", "username", 
				gtk_entry_get_text(GTK_ENTRY(eduname)));

		if (*pwd) {
			md5_init(&md5state);
			md5_append(&md5state, (unsigned const char *)pwd, strlen(pwd));
			md5_finish(&md5state, md5pword);
			xmms_cfg_write_string(cfgfile, "audioscrobbler", "password",
					hexify(md5pword, sizeof(md5pword)));
		}
		xmms_cfg_write_default_file(cfgfile);
		xmms_cfg_free(cfgfile);
	}
	gtk_widget_destroy(GTK_WIDGET(data));
}

void configure_dialog(void)
{
	static GtkWidget *cnfdlg;
	GtkWidget	*btnok,
			*btncancel,
			*vbox,
			*hbox,
			*unhbox,
			*pwhbox,
			*lblun,
			*lblpw,
			*frame;
			
	ConfigFile 	*cfgfile;
	
	if (cnfdlg)
		return;
	cnfdlg = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(cnfdlg), "XMMS scrobbler configuration");
	gtk_signal_connect(GTK_OBJECT(cnfdlg), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &cnfdlg);
	
	vbox = gtk_vbox_new(FALSE, 0);

	unhbox = gtk_hbox_new(FALSE, 0);
	eduname = gtk_entry_new();
	lblun = gtk_label_new("Username");
	gtk_box_pack_start(GTK_BOX(unhbox), lblun, FALSE, FALSE, 3);
	gtk_box_pack_start(GTK_BOX(unhbox), eduname, FALSE, FALSE, 3);
	
	pwhbox = gtk_hbox_new(FALSE, 0);
	edpwd = gtk_entry_new();
	lblpw = gtk_label_new("Password");
	gtk_entry_set_visibility(GTK_ENTRY(edpwd), FALSE);
	gtk_box_pack_start(GTK_BOX(pwhbox), lblpw, FALSE, FALSE, 3);
	gtk_box_pack_start(GTK_BOX(pwhbox), edpwd, FALSE, FALSE, 3);
	
	gtk_box_pack_start(GTK_BOX(vbox), unhbox, FALSE, FALSE, 3);
	gtk_box_pack_start(GTK_BOX(vbox), pwhbox, FALSE, FALSE, 3);
	
	hbox = gtk_hbox_new(FALSE, 0);
	
	btnok = gtk_button_new_with_label("OK");
	gtk_signal_connect(GTK_OBJECT(btnok), "clicked",
			GTK_SIGNAL_FUNC(saveconfig), GTK_OBJECT(cnfdlg));
	
	btncancel = gtk_button_new_with_label("Cancel");
	gtk_signal_connect_object(GTK_OBJECT(btncancel), "clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(cnfdlg));
	
	gtk_box_pack_start(GTK_BOX(hbox), btnok, FALSE, FALSE, 3);
	gtk_box_pack_start(GTK_BOX(hbox), btncancel, FALSE, FALSE, 3);
	
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 3);

	frame = gtk_frame_new("the plugin will have to be restarted for changes to take effect");
	gtk_container_add(GTK_CONTAINER(frame), vbox);
	gtk_container_add(GTK_CONTAINER(cnfdlg), frame);
	if ((cfgfile = xmms_cfg_open_default_file())) {
		gchar *username = NULL;
		xmms_cfg_read_string(cfgfile, "audioscrobbler", "username",
			&username);
		if (username) {
			gtk_entry_set_text(GTK_ENTRY(eduname), username);
			g_free(username);
		}
		xmms_cfg_free(cfgfile);
	}
	
	gtk_widget_show_all(cnfdlg);
}
